/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.worlds.together.util;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import org.betterx.bclib.BCLib;

public class DatapackConfigs {
    private static DatapackConfigs INSTANCE = new DatapackConfigs();
    private Map<ResourceLocation, DatapackConfigReloadHandler> handlers = new HashMap<ResourceLocation, DatapackConfigReloadHandler>();

    public static DatapackConfigs instance() {
        return INSTANCE;
    }

    public void register(String modID, String fileName, DatapackConfigReloadHandler handler) {
        this.register(modID, fileName, () -> {}, handler);
    }

    public void register(final String modID, final String fileName, final DatapackConfigReloadPrepare prepare, final DatapackConfigReloadHandler handler) {
        final ResourceLocation handlerID = new ResourceLocation(modID, "config_manager_" + fileName.replaceAll("/", "_").replaceAll(".", "_"));
        ResourceManagerHelper.get((PackType)PackType.SERVER_DATA).registerReloadListener((IdentifiableResourceReloadListener)new SimpleSynchronousResourceReloadListener(){

            public ResourceLocation getFabricId() {
                return handlerID;
            }

            public void m_6213_(ResourceManager manager) {
                prepare.onReload();
                DatapackConfigs.this.runForResources(manager, modID, fileName, handler);
            }
        });
    }

    public void runForResources(ResourceManager manager, String modID, String fileName, DatapackConfigReloadHandler handler) {
        for (Map.Entry entry : manager.m_214159_("config", id -> id.m_135827_().equals(modID) && id.m_135815_().endsWith(fileName)).entrySet()) {
            try {
                BufferedReader reader = ((Resource)entry.getValue()).m_215508_();
                try {
                    JsonObject obj = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                    if (obj == null) continue;
                    handler.onReload((ResourceLocation)entry.getKey(), obj);
                }
                finally {
                    if (reader == null) continue;
                    ((Reader)reader).close();
                }
            }
            catch (Exception e) {
                BCLib.LOGGER.error("Error occurred while loading resource json " + entry.getKey(), e);
            }
        }
    }

    @FunctionalInterface
    public static interface DatapackConfigReloadPrepare {
        public void onReload();
    }

    @FunctionalInterface
    public static interface DatapackConfigReloadHandler {
        public void onReload(ResourceLocation var1, JsonObject var2);
    }
}

